/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.management.schedule.condition.ScheduleWaitCondition;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public abstract class TimedWaitCondition
extends ScheduleWaitCondition {
    protected void requestDisplayIfNecessary(class_2487 context, int time) {
        int ticksUntilDeparture = this.totalWaitTicks() - time;
        if (ticksUntilDeparture < 1200 && ticksUntilDeparture % 100 == 0) {
            this.requestStatusToUpdate(context);
        }
        if (ticksUntilDeparture >= 1200 && ticksUntilDeparture % 1200 == 0) {
            this.requestStatusToUpdate(context);
        }
    }

    public int totalWaitTicks() {
        return this.getValue() * this.getUnit().ticksPer;
    }

    public TimedWaitCondition() {
        this.data.method_10569("Value", 5);
        this.data.method_10569("TimeUnit", TimeUnit.SECONDS.ordinal());
    }

    protected class_2561 formatTime(boolean compact) {
        if (compact) {
            return Components.literal(this.getValue() + this.getUnit().suffix);
        }
        return Components.literal(this.getValue() + " ").method_10852((class_2561)Lang.translateDirect(this.getUnit().key, new Object[0]));
    }

    @Override
    public List<class_2561> getTitleAs(String type) {
        return ImmutableList.of((Object)Components.translatable(this.getId().method_12836() + ".schedule." + type + "." + this.getId().method_12832()), (Object)Lang.translateDirect("schedule.condition.for_x_time", this.formatTime(false)).method_27692(class_124.field_1062));
    }

    @Override
    public class_1799 getSecondLineIcon() {
        return new class_1799((class_1935)class_1802.field_8619);
    }

    @Override
    public List<class_2561> getSecondLineTooltip(int slot) {
        return ImmutableList.of((Object)Lang.translateDirect("generic.duration", new Object[0]));
    }

    public int getValue() {
        return this.intData("Value");
    }

    public TimeUnit getUnit() {
        return this.enumData("TimeUnit", TimeUnit.class);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        builder.addScrollInput(0, 31, (i, l) -> {
            i.titled(Lang.translateDirect("generic.duration", new Object[0])).withShiftStep(15).withRange(0, 121);
            i.lockedTooltipX = -15;
            i.lockedTooltipY = 35;
        }, "Value");
        builder.addSelectionScrollInput(36, 85, (i, l) -> i.forOptions(TimeUnit.translatedOptions()).titled(Lang.translateDirect("generic.timeUnit", new Object[0])), "TimeUnit");
    }

    @Override
    public class_5250 getWaitingStatus(class_1937 level, Train train, class_2487 tag) {
        int time = tag.method_10550("Time");
        int ticksUntilDeparture = this.totalWaitTicks() - time;
        boolean showInMinutes = ticksUntilDeparture >= 1200;
        int num = (int)(showInMinutes ? Math.floor((float)ticksUntilDeparture / 1200.0f) : Math.ceil((float)ticksUntilDeparture / 100.0f) * 5.0);
        String key = "generic." + (showInMinutes ? (num == 1 ? "daytime.minute" : "unit.minutes") : (num == 1 ? "daytime.second" : "unit.seconds"));
        return Lang.translateDirect("schedule.condition." + this.getId().method_12832() + ".status", Components.literal(num + " ").method_10852((class_2561)Lang.translateDirect(key, new Object[0])));
    }

    public static enum TimeUnit {
        TICKS(1, "t", "generic.unit.ticks"),
        SECONDS(20, "s", "generic.unit.seconds"),
        MINUTES(1200, "min", "generic.unit.minutes");

        public int ticksPer;
        public String suffix;
        public String key;

        private TimeUnit(int ticksPer, String suffix, String key) {
            this.ticksPer = ticksPer;
            this.suffix = suffix;
            this.key = key;
        }

        public static List<class_2561> translatedOptions() {
            return Lang.translatedOptions(null, TimeUnit.TICKS.key, TimeUnit.SECONDS.key, TimeUnit.MINUTES.key);
        }
    }
}

